<?php
include('sabitsayfalar/header.php');

// Resim yolu fonksiyonu
function danismanlikResimYolu($danismanlik, $base_url, $dosya_path, $dosya_url, $base_firm_id) {
    $resim_path = '/upload-consulting/' . $base_firm_id . '/' . $danismanlik['danismanlik_resim'];
    $tam_yol = $dosya_path . $resim_path;

    if (empty($danismanlik['danismanlik_resim']) || !file_exists($tam_yol)) {
        return $base_url . 'images/news/s1.webp'; // varsayılan resim
    } else {
        return $dosya_url . $resim_path;
    }
}

$ait_id = (int)$seorow['seo_ait_id'];
$danismanlik_onay = 1;

$sorgumetni = "SELECT * FROM danismanlik 
    INNER JOIN danismanlik_dil ON danismanlik_id = danismanlikdil_danismanlik_id 
    WHERE (
        danismanlik_id = (
            SELECT MAX(danismanlik_id) FROM danismanlik 
            WHERE danismanlik_id < :danismanlik_id 
              AND danismanlik_onay = :danismanlik_onay
              AND danismanlik_userfirm_id = :basekayit
        ) 
        OR danismanlik_id = :danismanlik_id 
        OR danismanlik_id = (
            SELECT MIN(danismanlik_id) FROM danismanlik 
            WHERE danismanlik_id > :danismanlik_id 
              AND danismanlik_onay = :danismanlik_onay
              AND danismanlik_userfirm_id = :basekayit
        )
    )
    AND danismanlik_onay = :danismanlik_onay 
    AND danismanlik_userfirm_id = :basekayit
    ORDER BY danismanlik_id ASC";

$stmt = $connPDO->prepare($sorgumetni);
$stmt->bindParam(':danismanlik_id', $ait_id, PDO::PARAM_INT);
$stmt->bindParam(':danismanlik_onay', $danismanlik_onay, PDO::PARAM_INT);
$stmt->bindParam(':basekayit', $base_firm_id, PDO::PARAM_INT);
$stmt->execute();

$row = $stmt->fetchAll(PDO::FETCH_ASSOC);

$mevcut_danismanlik = null;
$onceki_danismanlik = null;
$sonraki_danismanlik = null;

foreach ($row as $key => $value) {
    if ($row[$key]['danismanlik_id'] == $ait_id) {
        $mevcut_danismanlik = $row[$key];

        if ($key > 0) {
            $onceki_danismanlik = $row[$key - 1];
        }

        if ($key < count($row) - 1) {
            $sonraki_danismanlik = $row[$key + 1];
        }
        break;
    }
}

$tarih = new DateTime($mevcut_danismanlik['danismanlik_eklenme_tarihi']);
$gun = $tarih->format('d');
$aylar = [
    '01' => 'Ocak', '02' => 'Şubat', '03' => 'Mart', '04' => 'Nisan',
    '05' => 'Mayıs', '06' => 'Haziran', '07' => 'Temmuz', '08' => 'Ağustos',
    '09' => 'Eylül', '10' => 'Ekim', '11' => 'Kasım', '12' => 'Aralık'
];
$ay = $aylar[$tarih->format('m')];
?>

<!-- HTML BAŞLANGICI -->
<section id="section-hero" class="section-dark no-top no-bottom text-light jarallax relative mh-500 jarallax">
    <img src="images/background/3.webp" class="jarallax-img" alt="">
    <div class="gradient-edge-bottom h-50"></div>
    <div class="sw-overlay op-5"></div>
    <div class="abs bottom-10 z-2 w-100">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-8">
                    <h1 class="text-start fs-48 fs-sm-10vw wow fadeIn" data-wow-delay=".6s">
                        <?= htmlspecialchars($mevcut_danismanlik['danismanlikdil_sayfaad']) ?>
                    </h1>
                </div>
                <div class="col-lg-2">
                    <div class="relative text-lg-end">
                        <div class="d-inline-block z-2 bg-color rounded-1 text-white p-4 text-center fw-600 wow fadeIn" data-wow-delay="1s">
                            <h4 class="fs-60 mb-0 lh-1"><?= $gun ?></h4>
                            <span class="fs-20 fw-60"><?= $ay ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section>
    <div class="container">
        <div class="row g-4 justify-content-center">
            <div class="col-lg-10">
                <div class="blog-read">
                    <div class="post-text">
                        <img src="<?= danismanlikResimYolu($mevcut_danismanlik, $base_url, $dosya_path, $dosya_url, $base_firm_id) ?>" class="w-100 rounded-1 mb-4" alt="">
                        <?= $mevcut_danismanlik['danismanlikdil_metni'] ?>
                    </div>
                    <div class="text-center mt-5">
                        <?php if (!empty($onceki_danismanlik['danismanlikdil_sayfaurl'])): ?>
                            <a href="<?= htmlspecialchars($base_url . $onceki_danismanlik['danismanlikdil_sayfaurl']) ?>" class="danismanlik-btn">
                                ← Önceki
                            </a>
                        <?php endif; ?>
                        <?php if (!empty($sonraki_danismanlik['danismanlikdil_sayfaurl'])): ?>
                            <a href="<?= htmlspecialchars($base_url . $sonraki_danismanlik['danismanlikdil_sayfaurl']) ?>" class="danismanlik-btn">
                                Sonraki →
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
</section>

<?php include('sabitsayfalar/footer.php'); ?>

<style>
    .danismanlik-btn {
        background-color: var(--bg-dark-1);
        color: var(--btn-color);
        font-family: var(--btn-font-family);
        font-size: var(--btn-font-size);
        font-weight: var(--btn-font-weight);
        letter-spacing: var(--btn-letter-spacing);
        padding: var(--btn-padding);
        border-radius: var(--btn-rounded);
        text-decoration: var(--btn-text-decoration);
        text-transform: var(--btn-text-transform);
        margin: 0 5px;
        display: inline-block;
        transition: background-color 0.3s ease;
    }
    .danismanlik-btn:hover {
        background-color: var(--btn-hover-bg);
        color: var(--btn-color);
    }
</style>
