<?php
include('sabitsayfalar/header.php');
?>

<section id="section-hero" class="section-dark no-top no-bottom text-light jarallax relative mh-500 jarallax">
    <img src="images/background/3.webp" class="jarallax-img" alt="">
    <div class="gradient-edge-bottom h-50"></div>
    <div class="sw-overlay op-5"></div>
    <div class="abs w-80 bottom-10 z-2 w-100">
        <div class="container">
            <div class="row align-items-center justify-content-between gx-5">
                <div class="col-lg-6">
                    <div class="relative wow mask-right">
                        <div class="text-start">
                            <h1 class="fs-100 fs-sm-10vw mb-0 lh-1">Danışmanlıklar</h1>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 wow fadeInRight" data-wow-delay=".3s">
                    <p class="mb-0" style="text-align: justify;"></p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
$danismanlik_onay = 1;
$kayit_sayisi = 9;

$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$sayfa = max($sayfa, 1);
$baslangic = ($sayfa - 1) * $kayit_sayisi;

$sorgu_toplam = "SELECT COUNT(*) as toplam FROM danismanlik 
                 INNER JOIN danismanlik_dil ON danismanlik_id = danismanlikdil_danismanlik_id
                 WHERE danismanlik_onay = :onay AND danismanlik_userfirm_id = :basekayit";
$stmt_toplam = $connPDO->prepare($sorgu_toplam);
$stmt_toplam->bindParam(':onay', $danismanlik_onay, PDO::PARAM_INT);
$stmt_toplam->bindParam(':basekayit', $base_firm_id, PDO::PARAM_INT);
$stmt_toplam->execute();
$toplam_kayit = $stmt_toplam->fetch(PDO::FETCH_ASSOC)['toplam'];
$toplam_sayfa = ceil($toplam_kayit / $kayit_sayisi);

$sorgu = "SELECT * FROM danismanlik 
          INNER JOIN danismanlik_dil ON danismanlik_id = danismanlikdil_danismanlik_id
          WHERE danismanlik_onay = :onay AND danismanlik_userfirm_id = :basekayit 
          ORDER BY danismanlik_eklenme_tarihi DESC 
          LIMIT :baslangic, :limit";
$stmt = $connPDO->prepare($sorgu);
$stmt->bindParam(':onay', $danismanlik_onay, PDO::PARAM_INT);
$stmt->bindParam(':basekayit', $base_firm_id, PDO::PARAM_INT);
$stmt->bindParam(':baslangic', $baslangic, PDO::PARAM_INT);
$stmt->bindParam(':limit', $kayit_sayisi, PDO::PARAM_INT);
$stmt->execute();

$danismanliklar = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<section>
    <div class="container">
        <div class="row g-4">
            <?php foreach ($danismanliklar as $row):
                $resim_path = '/upload-consulting/' . $base_firm_id . '/' . $row['danismanlik_resim'];
                $gercek_yol = $dosya_path . $resim_path;
                $resimYolu = (!empty($row['danismanlik_resim']) && file_exists($gercek_yol))
                    ? $dosya_url . $resim_path
                    : $base_url . 'images/news/s1.webp';
                $detayUrl = $base_url . $row['danismanlikdil_sayfaurl'];
                ?>
                <div class="col-lg-4">
                    <a href="<?= $detayUrl ?>" class="d-block hover relative rounded-20 overflow-hidden text-light">
                        <img src="<?= $resimYolu ?>" class="w-100 hover-scale-1-1" alt="">
                        <div class="absolute start-0 bottom-0 p-4 z-2">
                            <h4><?= htmlspecialchars($row['danismanlikdil_sayfaad']) ?></h4>
                        </div>
                        <div class="gradient-edge-bottom h-70"></div>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- Sayfalama -->
        <div class="col-lg-12 pt-4 text-center">
            <div class="d-inline-block">
                <nav aria-label="Page navigation">
                    <ul class="pagination">
                        <?php if ($sayfa > 1): ?>
                            <li class="page-item">
                                <a class="page-link" href="?sayfa=<?= $sayfa - 1 ?>" aria-label="Previous">
                                    <span><i class="fa fa-chevron-left"></i></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php for ($i = 1; $i <= $toplam_sayfa; $i++): ?>
                            <li class="page-item <?= $i == $sayfa ? 'active' : '' ?>">
                                <a class="page-link" href="?sayfa=<?= $i ?>"><?= $i ?></a>
                            </li>
                        <?php endfor; ?>
                        <?php if ($sayfa < $toplam_sayfa): ?>
                            <li class="page-item">
                                <a class="page-link" href="?sayfa=<?= $sayfa + 1 ?>" aria-label="Next">
                                    <span><i class="fa fa-chevron-right"></i></span>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</section>

<?php
include('sabitsayfalar/footer.php');
?>
