<?php
include('sabitsayfalar/header.php');

// Resim fonksiyonu
function duyuruResimYolu($duyuru, $base_url) {
    $resim_path = $duyuru['duyuru_resim'];
    $tam_yol = __DIR__ . '/' . $resim_path;

    if (empty($resim_path) || !file_exists($tam_yol)) {
        return 'images/news/s1.webp'; // varsayılan resim
    } else {
        return $base_url . '/' . $resim_path;
    }
}
$ait_id = (int)$seorow['seo_ait_id'];
$duyuru_onay = 1;

$sorgumetni = "SELECT * FROM duyurular 
    INNER JOIN duyuru_dil ON duyuru_id = duyurudil_duyuru_id 
    WHERE (
        duyuru_id = (
            SELECT MAX(duyuru_id) FROM duyurular 
            WHERE duyuru_id < :duyuru_id 
              AND duyuru_onay = :duyuru_onay
              AND duyuru_userfirm_id = :basekayit
        ) 
        OR duyuru_id = :duyuru_id 
        OR duyuru_id = (
            SELECT MIN(duyuru_id) FROM duyurular 
            WHERE duyuru_id > :duyuru_id 
              AND duyuru_onay = :duyuru_onay
              AND duyuru_userfirm_id = :basekayit
        )
    )
    AND duyuru_onay = :duyuru_onay 
    AND duyuru_userfirm_id = :basekayit
    ORDER BY duyuru_id ASC";

$stmt = $connPDO->prepare($sorgumetni);
$stmt->bindParam(':duyuru_id', $ait_id, PDO::PARAM_INT);
$stmt->bindParam(':duyuru_onay', $duyuru_onay, PDO::PARAM_INT);
$stmt->bindParam(':basekayit', $base_firm_id, PDO::PARAM_INT);
$stmt->execute();


$row = $stmt->fetchAll(PDO::FETCH_ASSOC);
$mevcut_duyuru = null;
$onceki_duyuru = null;
$sonraki_duyuru = null;

foreach ($row as $key => $value) {
    if ($row[$key]['duyuru_id'] == $ait_id) {
        $mevcut_duyuru = $row[$key];

        if ($key > 0) {
            $onceki_duyuru = $row[$key - 1];
        }

        if ($key < count($row) - 1) {
            $sonraki_duyuru = $row[$key + 1];
        }

        break;
    }
}

// Gün ve ay bilgisi
$tarih = new DateTime($mevcut_duyuru['duyuru_eklenme_tarihi']);
$gun = $tarih->format('d');
$aylar = [
    '01' => 'Ocak', '02' => 'Şubat', '03' => 'Mart', '04' => 'Nisan',
    '05' => 'Mayıs', '06' => 'Haziran', '07' => 'Temmuz', '08' => 'Ağustos',
    '09' => 'Eylül', '10' => 'Ekim', '11' => 'Kasım', '12' => 'Aralık'
];
$ay = $aylar[$tarih->format('m')];
?>

<!-- HTML BAŞLANGICI -->
<section id="section-hero" class="section-dark no-top no-bottom text-light jarallax relative mh-500 jarallax">
    <img src="images/background/3.webp" class="jarallax-img" alt="">
    <div class="gradient-edge-bottom h-50"></div>
    <div class="sw-overlay op-5"></div>
    <div class="abs bottom-10 z-2 w-100">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-8">
                    <h1 class="text-start fs-48 fs-sm-10vw wow fadeIn" data-wow-delay=".6s">
                        <?= htmlspecialchars($mevcut_duyuru['duyurudil_sayfaad']) ?>
                    </h1>
                </div>
                <div class="col-lg-2">
                    <div class="relative text-lg-end">
                        <div class="d-inline-block z-2 bg-color rounded-1 text-white p-4 text-center fw-600 wow fadeIn" data-wow-delay="1s">
                            <h4 class="fs-60 mb-0 lh-1"><?= $gun ?></h4>
                            <span class="fs-20 fw-60"><?= $ay ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section>
    <div class="container">
        <div class="row g-4 justify-content-center">
            <div class="col-lg-10">
                <div class="blog-read">

                    <div class="post-text">

                        <img src="<?= duyuruResimYolu($mevcut_duyuru, $base_url) ?>" class="w-100 rounded-1 mb-4" alt="">
                        <?= $mevcut_duyuru['duyurudil_metni'] ?>

                    </div>
                    <div class="text-center mt-5">
                        <?php if (!empty($onceki_duyuru['duyurudil_sayfaurl'])): ?>
                            <a href="<?= htmlspecialchars($base_url . $onceki_duyuru['duyurudil_sayfaurl']) ?>" class="duyuru-btn">
                                ← Önceki
                            </a>
                        <?php endif; ?>
                        <?php if (!empty($sonraki_duyuru['duyurudil_sayfaurl'])): ?>
                            <a href="<?= htmlspecialchars($base_url . $sonraki_duyuru['duyurudil_sayfaurl']) ?>" class="duyuru-btn">
                                Sonraki →
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
        </div>
    </div>
</section>

<?php include('sabitsayfalar/footer.php'); ?>

<script>
    // Sayfaya özel JS kodları
</script>

<style>
    .duyuru-btn {
        background-color: var(--bg-dark-1);
        color: var(--btn-color);
        font-family: var(--btn-font-family);
        font-size: var(--btn-font-size);
        font-weight: var(--btn-font-weight);
        letter-spacing: var(--btn-letter-spacing);
        padding: var(--btn-padding);
        border-radius: var(--btn-rounded);
        text-decoration: var(--btn-text-decoration);
        text-transform: var(--btn-text-transform);
        margin: 0 5px;
        display: inline-block;
        transition: background-color 0.3s ease;
    }

    .duyuru-btn:hover {
        background-color: var(--btn-hover-bg);
        color: var(--btn-color);
    }

</style>
