<?php
include('sabitsayfalar/header.php');
?>



<section id="section-girisimci" class="section-dark no-top no-bottom text-light jarallax relative mh-500 jarallax">
    <img src="images/background/3.webp" class="jarallax-img" alt="">
    <div class="gradient-edge-bottom h-50"></div>
    <div class="sw-overlay op-5"></div>
    <div class="abs bottom-10 z-2 w-100">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-10">
                    <h1 class="text-start fs-48 fs-sm-10vw wow fadeIn" data-wow-delay=".6s">
                        Girişimci Başvurusu
                    </h1>

                </div>
            </div>
        </div>
    </div>
</section>
<section id="section-girisimci-form">
    <div class="container">
        <div class="row g-4 justify-content-center">
            <div class="col-lg-10">
                <div class="blog-read">

                    <div class="post-text">

                        <img src="images/misc/1.png" class="w-100 rounded-1 mb-4" alt="">
                        <p>Zirve Girişim Merkezi, dijital dönüşüm, ileri üretim teknolojileri, yapay zeka, veri analitiği, otomasyon ve sürdürülebilirlik alanlarında yenilikçi iş fikirlerine sahip girişimcilere destek sunar. İş fikrinizi geliştirmek, prototiplemek ve ticarileştirmek için mentorluk, eğitim, yatırım ağına erişim ve açık ofis olanaklarından yararlanmak istiyorsanız başvurunuzu hemen yapın. Başvurular, teknik yeterlilik, yenilikçilik ve uygulanabilirlik kriterlerine göre değerlendirilir.</p>
                    </div>

                </div>

                <div class="spacer-single"></div>

                <div id="blog-comment-girisimci">
                    <h4>Girişimci Başvurusu Formu</h4>

                    <div class="spacer-half"></div>

                    <div class="spacer-single"></div>

                    <div id="comment-form-wrapper-girisimci">
                        <div class="comment_form_holder">
                            <?php
                            if ($_SERVER["REQUEST_METHOD"] === "POST") {
                                $girisimci_ad           = $_POST['girisimci_ad'] ?? '';
                                $girisimci_soyad        = $_POST['girisimci_soyad'] ?? '';
                                $girisimci_email        = $_POST['girisimci_email'] ?? '';
                                $girisimci_telefon      = $_POST['girisimci_telefon'] ?? '';
                                $girisimci_sirket_adi   = $_POST['girisimci_sirket_adi'] ?? '';
                                $girisimci_kurulus_yili = $_POST['girisimci_kurulus_yili'] ?? null;
                                $girisimci_faaliyet_alani = $_POST['girisimci_faaliyet_alani'] ?? '';
                                $girisimci_proje_fikri  = $_POST['girisimci_proje_fikri'] ?? '';
                                $girisimci_hedef_pazar  = $_POST['girisimci_hedef_pazar'] ?? '';
                                $girisimci_beklentiler  = $_POST['girisimci_beklentiler'] ?? '';
                                $girisimci_teknolojik_ihtiyaclar = $_POST['girisimci_teknolojik_ihtiyaclar'] ?? '';
                                $girisimci_referanslar  = $_POST['girisimci_referanslar'] ?? '';
                                $girisimci_ekip         = $_POST['girisimci_ekip'] ?? '';
                                $girisimci_motivasyon   = $_POST['girisimci_motivasyon'] ?? '';

                                // Dosya işlemleri
                                $dosyaAdi = $dosyaUzantisi = $veritabaniYolu = null;
                                $izinliUzantilar = ['pdf', 'doc', 'docx', 'zip', 'rar'];
                                $maxBoyut = 5 * 1024 * 1024; // 5MB

                                if (isset($_FILES['dosya']) && $_FILES['dosya']['error'] === UPLOAD_ERR_OK) {
                                    $dosyaBoyutu = $_FILES['dosya']['size'];
                                    $orjinalAd = $_FILES['dosya']['name'];
                                    $dosyaUzantisi = strtolower(pathinfo($orjinalAd, PATHINFO_EXTENSION));

                                    if (!in_array($dosyaUzantisi, $izinliUzantilar)) {
                                        echo '<div class="alert alert-warning">Yalnızca pdf, doc, docx, zip ve rar uzantılı dosyalar yüklenebilir.</div>';
                                    } elseif ($dosyaBoyutu > $maxBoyut) {
                                        echo '<div class="alert alert-warning">Dosya boyutu 5MB\'dan büyük olamaz.</div>';
                                    } else {
                                        $dosyaAdi = uniqid('girisimci_') . '.' . $dosyaUzantisi;
                                        $yuklemeKlasoru = $dosya_path . '/upload-entrepreneur/';
                                        if (!is_dir($yuklemeKlasoru)) {
                                            mkdir($yuklemeKlasoru, 0777, true);
                                        }

                                        $dosyaYolu = $yuklemeKlasoru . $dosyaAdi;
                                        $veritabaniYolu = '/upload-entrepreneur/' . $dosyaAdi;

                                        if (!move_uploaded_file($_FILES['dosya']['tmp_name'], $dosyaYolu)) {
                                            echo '<div class="alert alert-danger">Dosya yükleme sırasında bir hata oluştu.</div>';
                                            $dosyaAdi = $dosyaUzantisi = $veritabaniYolu = null;
                                        }
                                    }
                                }

                                // Veritabanına kayıt
                                try {
                                    $sorgu = $connPDO->prepare("
            INSERT INTO girisimci_basvuru (
                girisimci_ad, girisimci_soyad, girisimci_email, girisimci_telefon,
                girisimci_sirket_adi, girisimci_kurulus_yili, girisimci_faaliyet_alani,
                girisimci_proje_fikri, girisimci_hedef_pazar, girisimci_beklentiler,
                girisimci_teknolojik_ihtiyaclar, girisimci_referanslar, girisimci_ekip,
                girisimci_motivasyon, dosya_adi, dosya_uzantisi, dosya_yolu
            ) VALUES (
                :ad, :soyad, :email, :telefon, :sirket_adi, :kurulus_yili, :faaliyet_alani,
                :proje_fikri, :hedef_pazar, :beklentiler, :teknolojik_ihtiyaclar, :referanslar,
                :ekip, :motivasyon, :dosya_adi, :dosya_uzantisi, :dosya_yolu
            )
        ");

                                    $sorgu->execute([
                                        ':ad' => $girisimci_ad,
                                        ':soyad' => $girisimci_soyad,
                                        ':email' => $girisimci_email,
                                        ':telefon' => $girisimci_telefon,
                                        ':sirket_adi' => $girisimci_sirket_adi,
                                        ':kurulus_yili' => $girisimci_kurulus_yili,
                                        ':faaliyet_alani' => $girisimci_faaliyet_alani,
                                        ':proje_fikri' => $girisimci_proje_fikri,
                                        ':hedef_pazar' => $girisimci_hedef_pazar,
                                        ':beklentiler' => $girisimci_beklentiler,
                                        ':teknolojik_ihtiyaclar' => $girisimci_teknolojik_ihtiyaclar,
                                        ':referanslar' => $girisimci_referanslar,
                                        ':ekip' => $girisimci_ekip,
                                        ':motivasyon' => $girisimci_motivasyon,
                                        ':dosya_adi' => $dosyaAdi,
                                        ':dosya_uzantisi' => $dosyaUzantisi,
                                        ':dosya_yolu' => $veritabaniYolu
                                    ]);

                                    echo '<div class="alert alert-success">Girişimci başvurunuz başarıyla kaydedildi.</div>';
                                } catch (PDOException $e) {
                                    echo '<div class="alert alert-danger">Hata oluştu: ' . $e->getMessage() . '</div>';
                                }
                            }
                            ?>

                            <form action="" method="POST" enctype="multipart/form-data" class="form-border">
                                <!-- Bilgilendirme -->
                                <p class="mb-3"><span class="text-danger">*</span> ile işaretli alanların doldurulması zorunludur.</p>

                                <div class="row g-4">
                                    <div class="col-md-6">
                                        <label>Ad <span class="text-danger">*</span></label>
                                        <input type="text" name="girisimci_ad" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Soyad <span class="text-danger">*</span></label>
                                        <input type="text" name="girisimci_soyad" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Email <span class="text-danger">*</span></label>
                                        <input type="email" name="girisimci_email" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Telefon <span class="text-danger">*</span></label>
                                        <input type="text" name="girisimci_telefon" id="telefon" class="form-control" required placeholder="0555 489 75 48" pattern="05\d{2} \d{3} \d{2} \d{2}">
                                    </div>
                                    <div class="col-md-6">
                                        <label>Şirket Adı <span class="text-danger">*</span></label>
                                        <input type="text" name="girisimci_sirket_adi" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Kuruluş Yılı <span class="text-danger">*</span></label>
                                        <input type="number" name="girisimci_kurulus_yili" class="form-control" min="1900" max="2099" required style="background-color: #fff; color: #000;">
                                    </div>
                                    <div class="col-12">
                                        <label>Faaliyet Alanı <span class="text-danger">*</span></label>
                                        <input type="text" name="girisimci_faaliyet_alani" class="form-control" maxlength="255" required>
                                    </div>
                                    <div class="col-12">
                                        <label>Proje Fikri <span class="text-danger">*</span></label>
                                        <textarea name="girisimci_proje_fikri" class="form-control" rows="3" required></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label>Hedef Pazar <span class="text-danger">*</span></label>
                                        <textarea name="girisimci_hedef_pazar" class="form-control" rows="3" required></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label>Beklentiler <span class="text-danger">*</span></label>
                                        <textarea name="girisimci_beklentiler" class="form-control" rows="3" required></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label>Teknolojik İhtiyaçlar</label>
                                        <textarea name="girisimci_teknolojik_ihtiyaclar" class="form-control" rows="3"></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label>Referanslar</label>
                                        <textarea name="girisimci_referanslar" class="form-control" rows="3"></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label>Ekip</label>
                                        <textarea name="girisimci_ekip" class="form-control" rows="3"></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label>Motivasyon <span class="text-danger">*</span></label>
                                        <textarea name="girisimci_motivasyon" class="form-control" rows="3" required></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label>Dosya Yükle</label>
                                        <input type="file" name="dosya" class="form-control" accept=".pdf,.doc,.docx,.zip,.rar" style="background-color: #fff; color: #000;">
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn-main fx-slide"><span>Başvuruyu Gönder</span></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
</section>



<?php
include('sabitsayfalar/footer.php');
?>

