<?php
include('sabitsayfalar/header.php');
?>


    <section id="section-hero" class="section-dark no-top no-bottom text-light jarallax relative mh-500 jarallax">
        <img src="images/background/3.webp" class="jarallax-img" alt="">
        <div class="gradient-edge-bottom h-50"></div>
        <div class="sw-overlay op-5"></div>
        <div class="abs w-80 bottom-10 z-2 w-100">
            <div class="container">
                <div class="row align-items-center justify-content-between gx-5">
                    <div class="col-lg-6">
                        <div class="relative wow mask-right">
                            <div class="text-start">
                                <h1 class="fs-96  fs-sm-10vw mb-0 lh-1">Haberler</h1>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 wow fadeInRight" data-wow-delay=".3s">
                        <p class="mb-0" style="text-align: justify;">

                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php
$haber_onay = 1;
$kayit_sayisi = 6;

// Sayfa kontrolü
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$sayfa = max($sayfa, 1);
$baslangic = ($sayfa - 1) * $kayit_sayisi;

// Toplam kayıt sayısı
$sorgu_toplam = "SELECT COUNT(*) as toplam FROM haberler 
                 INNER JOIN haber_dil ON haber_id = haberdil_haber_id 
                 WHERE haber_onay = :onay AND haber_userfirm_id = :basekayit";
$stmt_toplam = $connPDO->prepare($sorgu_toplam);
$stmt_toplam->bindParam(':onay', $haber_onay, PDO::PARAM_INT);
$stmt_toplam->bindParam(':basekayit', $base_firm_id, PDO::PARAM_INT);
$stmt_toplam->execute();
$toplam_kayit = $stmt_toplam->fetch(PDO::FETCH_ASSOC)['toplam'];
$toplam_sayfa = ceil($toplam_kayit / $kayit_sayisi);

// Asıl veriyi çek
$sorgu = "SELECT * FROM haberler 
          INNER JOIN haber_dil ON haber_id = haberdil_haber_id
          WHERE haber_onay = :onay AND haber_userfirm_id = :basekayit 
          ORDER BY haber_eklenme_tarihi DESC 
          LIMIT :baslangic, :limit";
$stmt = $connPDO->prepare($sorgu);
$stmt->bindParam(':onay', $haber_onay, PDO::PARAM_INT);
$stmt->bindParam(':basekayit', $base_firm_id, PDO::PARAM_INT);
$stmt->bindParam(':baslangic', $baslangic, PDO::PARAM_INT);
$stmt->bindParam(':limit', $kayit_sayisi, PDO::PARAM_INT);
$stmt->execute();
?>

    <section>
        <div class="container">
            <div class="row g-4">
                <?php
                $aylar = ['01'=>'Ocak','02'=>'Şubat','03'=>'Mart','04'=>'Nisan','05'=>'Mayıs','06'=>'Haziran',
                    '07'=>'Temmuz','08'=>'Ağustos','09'=>'Eylül','10'=>'Ekim','11'=>'Kasım','12'=>'Aralık'];

                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    $tarih = new DateTime($row['haber_eklenme_tarihi']);
                    $gun = $tarih->format('d');
                    $ay = $aylar[$tarih->format('m')];
                    $haber_resim = $row['haber_resim'];
                    $resim_path = '/upload-news/' . $base_firm_id . '/' . $haber_resim ;
                    $gercek_yol = $dosya_path . $resim_path;
                    $resimYolu = (!empty($row['haber_resim']) && file_exists($gercek_yol))
                        ? $dosya_url . $resim_path
                        : $base_url . 'images/news/s1.webp';
                    $detayUrl = $base_url . $row['haberdil_sayfaurl'];
                    ?>
                    <div class="col-lg-4">
                        <a href="<?php echo $detayUrl; ?>" class="d-block hover relative rounded-20 overflow-hidden text-light" style="height: 450px;">

                            <!-- Resim kutunun tamamını kaplar -->
                            <img src="<?php echo $resimYolu; ?>"
                                 alt=""
                                 style="width: 100%; height: 100%; object-fit: cover; position: absolute; top: 0; left: 0; z-index: 0;">

                            <!-- Üstteki tarih etiketi -->
                            <div class="abs z-2 bg-color rounded-2 text-white p-3 pb-2 m-4 text-center fw-600">
                                <h4 class="fs-36 mb-0 lh-1"><?php echo $gun; ?></h4>
                                <span><?php echo $ay; ?></span>
                            </div>

                            <!-- Metin alanı -->
                            <div class="absolute start-0 bottom-0 p-4 z-2">
                                <h4 style="text-shadow: 0 1px 3px rgba(0,0,0,0.8);">
                                    <?php echo $row['haberdil_sayfaad']; ?>
                                </h4>
                            </div>

                            <!-- Alt gradient efekti -->
                            <div class="gradient-edge-bottom h-70"></div>
                        </a>
                    </div>

                <?php } ?>
                <div class="col-lg-12 pt-4 text-center">
                    <div class="d-inline-block">
                        <nav aria-label="Page navigation">
                            <ul class="pagination">
                                <?php if ($sayfa > 1): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?sayfa=<?php echo $sayfa - 1; ?>" aria-label="Previous">
                                            <span><i class="fa fa-chevron-left"></i></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php for ($i = 1; $i <= $toplam_sayfa; $i++): ?>
                                    <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                                        <a class="page-link" href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
                                    </li>
                                <?php endfor; ?>
                                <?php if ($sayfa < $toplam_sayfa): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?sayfa=<?php echo $sayfa + 1; ?>" aria-label="Next">
                                            <span><i class="fa fa-chevron-right"></i></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="pt-5 pb-5">
        <div class="container">
            <div class="row align-items-center justify-content-between mb-4">
                <div class="col-lg-6 wow fadeInLeft">
                    <h2 class="fs-48 fw-600 mb-0">Basında Biz</h2>
                </div>
                <div class="col-lg-6 wow fadeInRight">
                    <p class="mb-0" style="text-align: justify;">
                        <!-- Açıklama istersen buraya -->
                    </p>
                </div>
            </div>

            <?php
            // Haberler dizisi (10 örnek)
            $basinda_haberler = [
                ['baslik' => 'DİJİTAL DÖNÜŞÜM PROGRAMI', 'link' => 'https://www.gebzeto.org.tr/dijital-donusum-programi/', 'resim' => 'images/news/logo.png'],
                ['baslik' => 'Darıca’da ücretsiz PLC eğitimlerine başladı', 'link' => 'https://www.stendustri.com.tr/daricada-ucretsiz-plc-egitimlerine-basladi', 'resim' => 'images/news/daricada_ucretsiz_plc_egitimlerine_basladi_h101505_2a4be.webp'],
                ['baslik' => 'Eğitimde ve endüstride dijital dönüşüm masaya yatırılacak', 'link' => 'https://www.stendustri.com.tr/egitimde-ve-endustride-dijital-donusum-masaya-yatirilacak', 'resim' => 'images/news/egitimde_ve_endustride_dijital_donusum_masaya_yatirilacak_h101247_309dc.webp'],
                ['baslik' => 'Maske makinasını üretime aldı, yoğun bakım cihazı geliştirmeye başladı', 'link' => 'https://www.stendustri.com.tr/maske-makinasini-uretime-aldi-yogun-bakim-cihazi-gelistirmeye-basladi', 'resim' => 'images/news/maske_makinasini_uretime_aldi_yogun_bakim_cihazi_gelistirmeye_basladi_h107067_251ff.jpg'],
                ['baslik' => 'NUHOĞLU: “TÜRKİYE’NİN DÖNÜŞÜMÜ İNSAN TEMELLİ OLMALI”', 'link' => 'https://www.stendustri.com.tr/nuhoglu-turkiyenin-donusumu-insan-temelli-olmali', 'resim' => 'images/news/nuhoglu_turkiyenin_donusumu_insan_temelli_olmali_h113475_da0e0.webp'],
                ['baslik' => 'HAMLE, MALVA KOZMETİK’İN DİJİTAL CHECK-UP’INI TAMAMLADI', 'link' => 'https://www.stendustri.com.tr/hamle-malva-kozmetikin-dijital-check-upini-tamamladi', 'resim' => 'images/news/hamle_malva_kozmetik_in_dijital_check_up_ini_tamamladi_h115096_258da.webp'],
                ['baslik' => 'Kocaeli Bilişim Fuarı’nda Gebzeli Atak Robot', 'link' => 'https://www.dunya.com/sehirler/kocaeli-bilisim-fuarinda-gebzeli-atak-robot-haberi-390655', 'resim' => 'images/news/390655.webp'],
                ['baslik' => 'HAMLE BİLİŞİM DijitalHAMLE İLE 60 FİRMAYA REHBERLİK YAPTI', 'link' => 'https://www.stendustri.com.tr/hamle-bilisim-dijitalhamle-ile-60-firmaya-rehberlik-yapti', 'resim' => 'images/news/hamle_bilisim_dijitalhamle_ile_60_firmaya_rehberlik_yapti_h117989_831d7.webp'],
                ['baslik' => 'Zirve’den önce Teknofest’te görücüye çıkardı', 'link' => 'https://www.stendustri.com.tr/zirveden-once-teknofestte-gorucuye-cikardi', 'resim' => 'images/news/hamle_teknofest_haber_h102368_ac4ef.webp'],
                ['baslik' => 'Başbakan Yardımcısı Işık’tan ’Atak Robot’a Özel İlgi', 'link' => 'https://www.milliyet.com.tr/yerel-haberler/kocaeli/basbakan-yardimcisi-isiktan-atak-robota-ozel-ilgi-12425957', 'resim' => 'images/news/5da2796e45d2a0b77898e0da.webp'],
            ];
            ?>

            <div class="owl-carousel owl-theme owl-nav-visible" id="basinda-carousel">
                <?php foreach ($basinda_haberler as $haber): ?>
                    <div class="item">
                        <a href="<?= htmlspecialchars($haber['link']) ?>" target="_blank"
                           class="d-block hover relative rounded-20 overflow-hidden text-light"
                           style="height: 450px;">
                            <img src="<?= htmlspecialchars($haber['resim']) ?>"
                                 alt="<?= htmlspecialchars($haber['baslik']) ?>"
                                 style="width: 100%; height: 100%; object-fit: cover; position: absolute; top: 0; left: 0; z-index: 0;">
                            <div class="absolute start-0 bottom-0 p-4 z-2">
                                <h4 style="text-shadow: 0 1px 3px rgba(0,0,0,0.8);">
                                    <?= htmlspecialchars($haber['baslik']) ?>
                                </h4>
                            </div>
                            <div class="gradient-edge-bottom h-70"></div>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Owl Carousel Başlat -->
    <script>
        $(document).ready(function(){
            $("#basinda-carousel").owlCarousel({
                loop: true,
                margin: 30,
                nav: true,
                dots: false,
                navText: [
                    '<i class="fa fa-chevron-left"></i>',
                    '<i class="fa fa-chevron-right"></i>'
                ],
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 2
                    },
                    992: {
                        items: 3
                    }
                }
            });
        });
    </script>





<?php
include('sabitsayfalar/footer.php');
?>