<?php include('sabitsayfalar/header.php'); ?>

<section id="section-teknoloji" class="section-dark no-top no-bottom text-light jarallax relative mh-500 jarallax">
    <img src="images/background/3.webp" class="jarallax-img" alt="">
    <div class="gradient-edge-bottom h-50"></div>
    <div class="sw-overlay op-5"></div>
    <div class="abs bottom-10 z-2 w-100">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-10">
                    <h1 class="text-start fs-48 fs-sm-10vw wow fadeIn" data-wow-delay=".6s">
                        Teknoloji Tedarikçisi Başvurusu
                    </h1>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="section-teknoloji-form">
    <div class="container">
        <div class="row g-4 justify-content-center">
            <div class="col-lg-10">
                <div class="blog-read">
                    <div class="post-text">
                        <img src="images/misc/DH PORTAL Banner (1920 x 600 piksel).png" class="w-100 rounded-1 mb-4" alt="">
                        <p>Teknolojik çözüm sunan firmaların tedarikçi havuzumuza katılması için başvuru formudur. Lütfen bilgileri eksiksiz doldurunuz.</p>
                    </div>
                </div>

                <div class="spacer-single"></div>

                <div id="blog-comment-teknoloji">
                    <h4>Başvuru Formu</h4>
                    <div class="spacer-half"></div>
                    <div class="spacer-single"></div>

                    <div id="comment-form-wrapper-teknoloji">
                        <div class="comment_form_holder">

                            <?php
                            if ($_SERVER["REQUEST_METHOD"] === "POST") {
                                $ad = $_POST['ad'] ?? '';
                                $soyad = $_POST['soyad'] ?? '';
                                $email = $_POST['email'] ?? '';
                                $telefon = $_POST['telefon'] ?? '';
                                $vergi_no = $_POST['vergi_no'] ?? '';
                                $firma_adres = $_POST['firma_adres'] ?? '';
                                $cozum = $_POST['cozum'] ?? '';

                                try {
                                    $stmt = $connPDO->prepare("
                                        INSERT INTO teknoloji_tedarik_basvuru (
                                            ad, soyad, email, telefon, vergi_no, firma_adres, cozum
                                        ) VALUES (
                                            :ad, :soyad, :email, :telefon, :vergi_no, :firma_adres, :cozum
                                        )
                                    ");
                                    $stmt->execute([
                                        ':ad' => $ad,
                                        ':soyad' => $soyad,
                                        ':email' => $email,
                                        ':telefon' => $telefon,
                                        ':vergi_no' => $vergi_no,
                                        ':firma_adres' => $firma_adres,
                                        ':cozum' => $cozum
                                    ]);

                                    echo '<div class="alert alert-success">Başvurunuz başarıyla kaydedildi.</div>';
                                } catch (PDOException $e) {
                                    echo '<div class="alert alert-danger">Hata oluştu: ' . $e->getMessage() . '</div>';
                                }
                            }
                            ?>

                            <form method="POST" class="form-border">
                                <div class="row g-4">
                                    <div class="col-md-6">
                                        <label>Ad <span class="text-danger">*</span></label>
                                        <input type="text" name="ad" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Soyad <span class="text-danger">*</span></label>
                                        <input type="text" name="soyad" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Email <span class="text-danger">*</span></label>
                                        <input type="email" name="email" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Telefon <span class="text-danger">*</span></label>
                                        <input type="text" name="telefon" class="form-control" required placeholder="05xx xxx xx xx">
                                    </div>
                                    <div class="col-md-6">
                                        <label>Firma Vergi Numarası <span class="text-danger">*</span></label>
                                        <input type="text" name="vergi_no" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label>Firma Adresi <span class="text-danger">*</span></label>
                                        <input type="text" name="firma_adres" class="form-control" required>
                                    </div>
                                    <div class="col-12">
                                        <label>Geliştirdiğiniz Teknolojik Çözüm <span class="text-danger">*</span></label>
                                        <textarea name="cozum" class="form-control" rows="4" required></textarea>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn-main fx-slide"><span>Başvuruyu Gönder</span></button>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

<?php include('sabitsayfalar/footer.php'); ?>
